@extends('pdf.base')

@section('title', 'Rutina - ' . $client->name)

@section('styles')
<style>
    /* Enhanced workout-specific styles with dynamic colors */
    .exercise-card {
        background: linear-gradient(135deg, {{ $settings['secondary_color'] ?? '#f97316' }}08 0%, #ffffff 100%);
        border: 1px solid {{ $settings['secondary_color'] ?? '#f97316' }}40;
        border-radius: 12px;
        margin-bottom: 12px;
        padding: 14px 16px;
        page-break-inside: avoid;
        position: relative;
        overflow: hidden;
    }
    
    .exercise-card::before {
        content: '';
        position: absolute;
        left: 0;
        top: 0;
        bottom: 0;
        width: 4px;
        background: linear-gradient(180deg, {{ $settings['primary_color'] ?? '#3b82f6' }}, {{ $settings['secondary_color'] ?? '#f97316' }});
    }
    
    .exercise-number {
        background: linear-gradient(135deg, {{ $settings['secondary_color'] ?? '#f97316' }} 0%, {{ $settings['primary_color'] ?? '#ea580c' }} 100%);
        color: white;
        width: 36px;
        height: 36px;
        border-radius: 10px;
        display: inline-block;
        text-align: center;
        line-height: 36px;
        font-weight: 700;
        font-size: 15px;
        float: left;
        margin-right: 14px;
        box-shadow: 0 2px 8px {{ $settings['secondary_color'] ?? '#f97316' }}40;
    }
    
    .exercise-name { 
        font-weight: 700; 
        font-size: 14px; 
        color: #1f2937;
        margin-bottom: 4px;
    }
    
    .muscle-group { 
        font-size: 10px; 
        color: #6b7280; 
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }
    
    .sets-reps-box {
        background: linear-gradient(135deg, {{ $settings['primary_color'] ?? '#3b82f6' }} 0%, {{ $settings['secondary_color'] ?? '#f97316' }} 100%);
        color: white;
        padding: 10px 18px;
        border-radius: 25px;
        font-size: 16px;
        font-weight: 700;
        text-align: center;
        display: inline-block;
        min-width: 90px;
        box-shadow: 0 3px 10px {{ $settings['primary_color'] ?? '#3b82f6' }}30;
    }
    
    .rest-badge {
        background: linear-gradient(135deg, {{ $settings['accent_color'] ?? '#10b981' }}20, {{ $settings['accent_color'] ?? '#10b981' }}10);
        color: {{ $settings['accent_color'] ?? '#10b981' }};
        border: 1px solid {{ $settings['accent_color'] ?? '#10b981' }}40;
        padding: 5px 14px;
        border-radius: 15px;
        font-size: 11px;
        font-weight: 600;
    }
    
    .equipment-tag {
        display: inline-block;
        padding: 3px 10px;
        background: {{ $settings['primary_color'] ?? '#3b82f6' }}15;
        color: {{ $settings['primary_color'] ?? '#3b82f6' }};
        border: 1px solid {{ $settings['primary_color'] ?? '#3b82f6' }}30;
        font-size: 9px;
        border-radius: 6px;
        margin-left: 8px;
        font-weight: 600;
    }
    
    .exercise-notes {
        font-size: 11px;
        color: #6b7280;
        font-style: italic;
        margin-top: 8px;
        padding: 8px 12px 8px 50px;
        background: #fafafa;
        border-radius: 8px;
        border-left: 3px solid {{ $settings['secondary_color'] ?? '#f97316' }};
    }
    
    .week-header {
        background: linear-gradient(135deg, {{ $settings['primary_color'] ?? '#3b82f6' }} 0%, {{ $settings['secondary_color'] ?? '#f97316' }} 100%);
        color: white;
        padding: 12px 20px;
        border-radius: 12px;
        font-size: 13px;
        font-weight: 700;
        text-transform: uppercase;
        letter-spacing: 1.5px;
        margin-bottom: 18px;
        text-align: center;
        box-shadow: 0 4px 15px {{ $settings['primary_color'] ?? '#3b82f6' }}25;
    }
    
    .summary-row {
        display: table;
        width: 100%;
        margin-bottom: 20px;
    }
    
    .summary-item {
        display: table-cell;
        text-align: center;
        padding: 10px;
    }
    
    .summary-value {
        font-size: 28px;
        font-weight: 700;
        color: {{ $settings['secondary_color'] ?? '#f97316' }};
        display: block;
    }
    
    .summary-label {
        font-size: 10px;
        color: #6b7280;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }
    
    /* Progress tracking section */
    .progress-track {
        border: 2px dashed {{ $settings['primary_color'] ?? '#3b82f6' }}40;
        border-radius: 12px;
        padding: 18px;
        margin-top: 25px;
        background: {{ $settings['primary_color'] ?? '#3b82f6' }}05;
    }
    
    .progress-track h4 {
        color: {{ $settings['primary_color'] ?? '#3b82f6' }};
        font-size: 12px;
        margin-bottom: 12px;
        font-weight: 600;
    }
    
    .checkbox-row {
        display: table;
        width: 100%;
    }
    
    .checkbox-cell {
        display: table-cell;
        text-align: center;
        padding: 6px;
        font-size: 10px;
    }
    
    .checkbox {
        width: 20px;
        height: 20px;
        border: 2px solid {{ $settings['primary_color'] ?? '#3b82f6' }}50;
        border-radius: 6px;
        display: inline-block;
        vertical-align: middle;
        margin-right: 5px;
        background: white;
    }
    
    /* Client info card */
    .client-card {
        background: linear-gradient(135deg, {{ $settings['secondary_color'] ?? '#f97316' }}10 0%, {{ $settings['secondary_color'] ?? '#f97316' }}05 100%);
        border: 1px solid {{ $settings['secondary_color'] ?? '#f97316' }}30;
        border-radius: 16px;
        padding: 18px;
    }
    
    .client-name {
        color: {{ $settings['secondary_color'] ?? '#f97316' }};
        font-size: 18px;
        font-weight: 700;
        margin-bottom: 12px;
    }
    
    /* Weekly program card */
    .program-card {
        border-radius: 16px;
        overflow: hidden;
        border: 1px solid #e5e7eb;
    }
    
    .program-header {
        background: linear-gradient(135deg, {{ $settings['primary_color'] ?? '#3b82f6' }} 0%, {{ $settings['secondary_color'] ?? '#f97316' }} 100%);
        color: white;
        padding: 12px 15px;
        font-weight: 600;
        font-size: 12px;
    }
    
    .program-body {
        padding: 15px;
        background: white;
    }
</style>
@endsection

@section('content')
    <!-- Modern Header with Coach Info -->
    <div class="pdf-header-modern" style="background: linear-gradient(135deg, {{ $settings['primary_color'] ?? '#3b82f6' }}, {{ $settings['secondary_color'] ?? '#f97316' }});">
        <div class="header-top">
            <div class="header-logo-area">
                @if(($settings['show_logo'] ?? true) && ($settings['logo'] ?? null))
                    <img src="{{ $settings['logo'] }}" alt="Logo">
                @else
                    <div class="header-logo-text">{{ $settings['header'] ?? 'CoachPro' }}</div>
                @endif
            </div>
            <div class="header-title-area">
                <h1>🏋️ {{ $settings['header_title'] ?? 'RUTINA DE ENTRENAMIENTO' }}</h1>
                <div class="subtitle">{{ $workout->name }}</div>
            </div>
            <div class="header-date-area">
                @if($settings['show_date'] ?? true)
                <div style="opacity: 0.8;">Fecha de creación</div>
                <div class="date-value">{{ $workout->created_at->format('d/m/Y') }}</div>
                @endif
            </div>
        </div>
        
        @if(($settings['show_coach_info'] ?? true) && !empty($coach))
        <div class="coach-info-box">
            <div class="coach-photo-area">
                @if(($settings['show_coach_photo'] ?? false) && ($coach['photo'] ?? null))
                    <img src="{{ $coach['photo'] }}" alt="Coach" class="coach-photo">
                @else
                    <div class="coach-photo-placeholder">👤</div>
                @endif
            </div>
            <div class="coach-details">
                <div class="coach-name">{{ $coach['name'] ?? 'Tu Entrenador Personal' }}</div>
                @if(($settings['show_coach_credentials'] ?? true) && ($coach['credentials'] ?? null))
                <div class="coach-credentials">{{ Str::limit($coach['credentials'], 60) }}</div>
                @endif
            </div>
            @if($settings['show_coach_contact'] ?? true)
            <div class="coach-contact">
                @if($coach['email'] ?? null)
                <div class="coach-contact-item">📧 {{ $coach['email'] }}</div>
                @endif
                @if($coach['phone'] ?? null)
                <div class="coach-contact-item">📱 {{ $coach['phone'] }}</div>
                @endif
            </div>
            @endif
        </div>
        @endif
    </div>

    <!-- Client Info & Quick Stats -->
    <div class="row mb-3">
        <div class="col-6" style="padding-right: 10px;">
            <div class="client-card">
                <h3 class="client-name">👤 {{ $client->name }}</h3>
                <div class="summary-row" style="margin-bottom: 0;">
                    @if($client->age)
                    <div class="summary-item">
                        <span class="summary-value" style="font-size: 24px;">{{ $client->age }}</span>
                        <span class="summary-label">Años</span>
                    </div>
                    @endif
                    @if($client->weight)
                    <div class="summary-item">
                        <span class="summary-value" style="font-size: 24px;">{{ $client->weight }}</span>
                        <span class="summary-label">Kg</span>
                    </div>
                    @endif
                    @if($client->height)
                    <div class="summary-item">
                        <span class="summary-value" style="font-size: 24px;">{{ $client->height }}</span>
                        <span class="summary-label">Cm</span>
                    </div>
                    @endif
                    @if($client->objective)
                    <div class="summary-item">
                        <span class="badge" style="background: {{ $settings['secondary_color'] ?? '#f97316' }}20; color: {{ $settings['secondary_color'] ?? '#f97316' }};">{{ ucfirst($client->objective) }}</span>
                        <span class="summary-label" style="display: block; margin-top: 5px;">Objetivo</span>
                    </div>
                    @endif
                </div>
            </div>
        </div>
        <div class="col-6" style="padding-left: 10px;">
            <div class="program-card">
                <div class="program-header">
                    📅 Programa Semanal
                </div>
                <div class="program-body">
                    @php
                        $allDays = [
                            'monday' => 'Lun',
                            'tuesday' => 'Mar',
                            'wednesday' => 'Mié',
                            'thursday' => 'Jue',
                            'friday' => 'Vie',
                            'saturday' => 'Sáb',
                            'sunday' => 'Dom',
                        ];
                    @endphp
                    <div style="text-align: center; margin-bottom: 12px;">
                        @foreach($allDays as $key => $label)
                            <span class="day-badge {{ in_array($key, $workout->days ?? []) ? 'day-active' : 'day-inactive' }}" style="{{ in_array($key, $workout->days ?? []) ? 'background: linear-gradient(135deg, ' . ($settings['primary_color'] ?? '#3b82f6') . ', ' . ($settings['secondary_color'] ?? '#f97316') . ');' : '' }}">
                                {{ $label }}
                            </span>
                        @endforeach
                    </div>
                    <div class="summary-row" style="margin-bottom: 0;">
                        <div class="summary-item">
                            <span class="summary-value" style="font-size: 22px; color: {{ $settings['primary_color'] ?? '#3b82f6' }};">{{ count($workout->days ?? []) }}</span>
                            <span class="summary-label">Días/Sem</span>
                        </div>
                        <div class="summary-item">
                            <span class="summary-value" style="font-size: 22px; color: {{ $settings['secondary_color'] ?? '#f97316' }};">{{ count($exercises) }}</span>
                            <span class="summary-label">Ejercicios</span>
                        </div>
                        @if($workout->duration_weeks)
                        <div class="summary-item">
                            <span class="summary-value" style="font-size: 22px; color: {{ $settings['accent_color'] ?? '#10b981' }};">{{ $workout->duration_weeks }}</span>
                            <span class="summary-label">Semanas</span>
                        </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Workout Description -->
    @if($workout->description)
    <div class="quote-box">
        <div class="quote-text">"{{ $workout->description }}"</div>
        <div class="quote-author">— Descripción del programa</div>
    </div>
    @endif

    <!-- Exercises Section -->
    <div class="section">
        <div class="week-header">
            🏋️ Ejercicios de la Rutina
        </div>
        
        @foreach($exercises as $index => $exercise)
        <div class="exercise-card">
            <div style="display: table; width: 100%;">
                <div style="display: table-cell; width: 50px; vertical-align: top;">
                    <div class="exercise-number">{{ $index + 1 }}</div>
                </div>
                <div style="display: table-cell; vertical-align: top; width: 45%;">
                    <div class="exercise-name">
                        {{ $exercise->name }}
                        @if($exercise->equipment)
                        <span class="equipment-tag">{{ $exercise->equipment }}</span>
                        @endif
                    </div>
                    <div class="muscle-group">{{ $exercise->muscle_group }}</div>
                </div>
                <div style="display: table-cell; text-align: center; vertical-align: middle; width: 28%;">
                    <div class="sets-reps-box">{{ $exercise->sets }} × {{ $exercise->reps }}</div>
                </div>
                <div style="display: table-cell; text-align: center; vertical-align: middle; width: 17%;">
                    @if($exercise->rest_seconds)
                        <span class="rest-badge">⏱ {{ $exercise->rest_seconds }}s</span>
                    @endif
                </div>
            </div>
            @if($exercise->notes)
            <div class="exercise-notes">
                💡 {{ $exercise->notes }}
            </div>
            @endif
        </div>
        @endforeach
    </div>

    <!-- Trainer Notes -->
    @if($workout->notes)
    <div class="info-box accent">
        <strong style="color: {{ $settings['primary_color'] ?? '#3b82f6' }};">📝 Notas del Entrenador:</strong>
        <p style="margin-top: 8px; color: #374151;">{{ $workout->notes }}</p>
    </div>
    @endif

    <!-- Progress Tracking Section -->
    <div class="progress-track">
        <h4>📊 Seguimiento de Progreso (Semana ___)</h4>
        <div class="checkbox-row">
            @foreach($allDays as $key => $label)
            <div class="checkbox-cell">
                <span class="checkbox"></span>
                {{ $label }}
            </div>
            @endforeach
        </div>
        <p style="font-size: 9px; color: #9ca3af; margin-top: 12px; text-align: center;">
            Marca cada día que completes tu entrenamiento. ¡Mantén la consistencia! 💪
        </p>
    </div>

    <!-- Modern Footer -->
    <div class="pdf-footer-modern">
        <div class="footer-content">
            <div class="footer-brand">
                <div class="footer-brand-logo">{{ $settings['header'] ?? 'CoachPro' }}</div>
                <div class="footer-brand-tagline">{{ $settings['footer_note'] ?? 'Tu éxito es nuestra misión' }}</div>
            </div>
            <div class="footer-contact">
                @if($settings['footer_website'] ?? null)
                <div class="footer-contact-item">🌐 {{ $settings['footer_website'] }}</div>
                @endif
                @if($settings['footer_email'] ?? null)
                <div class="footer-contact-item">📧 {{ $settings['footer_email'] }}</div>
                @endif
                @if($settings['footer_phone'] ?? null)
                <div class="footer-contact-item">📱 {{ $settings['footer_phone'] }}</div>
                @endif
            </div>
            <div class="footer-legal">
                <p>{{ $settings['footer_text'] ?? $settings['footer'] ?? '' }}</p>
                <p style="margin-top: 5px;">Esta rutina fue diseñada especialmente para ti</p>
                <p>¡Éxito en tu entrenamiento! 💪</p>
            </div>
        </div>
    </div>
@endsection
