<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <title>Plan de Alimentación - {{ $client->name }}</title>
    <style>
        body {
            font-family: 'DejaVu Sans', sans-serif;
            font-size: 11px;
            line-height: 1.5;
            color: #333;
        }
        .header {
            background-color: #22c55e;
            color: white;
            padding: 20px;
            margin: -20px -20px 20px -20px;
        }
        .header h1 {
            margin: 0;
            font-size: 22px;
        }
        .header p {
            margin: 5px 0 0 0;
            opacity: 0.9;
        }
        .client-info {
            background-color: #f0fdf4;
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 20px;
        }
        .client-info h3 {
            margin: 0 0 10px 0;
            color: #16a34a;
        }
        .macros-summary {
            display: flex;
            justify-content: space-around;
            background-color: #f8fafc;
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 20px;
            border: 1px solid #e2e8f0;
        }
        .macro-box {
            text-align: center;
        }
        .macro-value {
            font-size: 20px;
            font-weight: bold;
        }
        .macro-label {
            font-size: 10px;
            color: #6b7280;
        }
        .calories { color: #8b5cf6; }
        .proteins { color: #3b82f6; }
        .carbs { color: #eab308; }
        .fats { color: #f97316; }
        .meal-section {
            margin-bottom: 20px;
            page-break-inside: avoid;
        }
        .meal-title {
            background-color: #16a34a;
            color: white;
            padding: 8px 15px;
            font-weight: bold;
            font-size: 12px;
            border-radius: 5px 5px 0 0;
        }
        .meal-table {
            width: 100%;
            border-collapse: collapse;
            border: 1px solid #e5e7eb;
            margin-bottom: 10px;
        }
        .meal-table th {
            background-color: #f3f4f6;
            padding: 8px;
            text-align: left;
            font-size: 10px;
        }
        .meal-table td {
            padding: 8px;
            border-bottom: 1px solid #e5e7eb;
        }
        .quantity {
            font-weight: bold;
            color: #16a34a;
        }
        .footer {
            margin-top: 30px;
            padding-top: 15px;
            border-top: 2px solid #22c55e;
            text-align: center;
            font-size: 10px;
            color: #6b7280;
        }
        .logo {
            font-size: 16px;
            font-weight: bold;
            color: #22c55e;
        }
        .goal-badge {
            display: inline-block;
            padding: 3px 10px;
            border-radius: 10px;
            font-size: 10px;
            font-weight: bold;
        }
        .goal-lose { background-color: #fee2e2; color: #dc2626; }
        .goal-maintain { background-color: #dbeafe; color: #2563eb; }
        .goal-gain { background-color: #dcfce7; color: #16a34a; }
    </style>
</head>
<body>
    <div class="header">
        <h1>{{ $mealPlan->name }}</h1>
        <p>{{ $mealPlan->description ?? 'Plan de alimentación personalizado' }}</p>
    </div>

    <div class="client-info">
        <h3>{{ $client->name }}</h3>
        <p>
            @if($client->tdee)
                TDEE: <strong>{{ $client->tdee }} kcal/día</strong> |
            @endif
            Objetivo: 
            <span class="goal-badge goal-{{ $mealPlan->goal_type }}">
                {{ $mealPlan->goal_type === 'lose' ? 'Perder peso' : ($mealPlan->goal_type === 'gain' ? 'Ganar masa' : 'Mantener') }}
                ({{ $mealPlan->goal_percentage > 0 ? '+' : '' }}{{ $mealPlan->goal_percentage }}%)
            </span>
        </p>
    </div>

    <div class="macros-summary">
        <div class="macro-box">
            <div class="macro-value calories">{{ round($totals['calories']) }}</div>
            <div class="macro-label">Calorías</div>
        </div>
        <div class="macro-box">
            <div class="macro-value proteins">{{ round($totals['proteins']) }}g</div>
            <div class="macro-label">Proteínas</div>
        </div>
        <div class="macro-box">
            <div class="macro-value carbs">{{ round($totals['carbs']) }}g</div>
            <div class="macro-label">Carbohidratos</div>
        </div>
        <div class="macro-box">
            <div class="macro-value fats">{{ round($totals['fats']) }}g</div>
            <div class="macro-label">Grasas</div>
        </div>
    </div>

    @foreach($groupedItems as $mealType => $items)
    <div class="meal-section">
        <div class="meal-title">{{ $mealLabels[$mealType] ?? ucfirst($mealType) }}</div>
        <table class="meal-table">
            <thead>
                <tr>
                    <th width="40%">Alimento</th>
                    <th width="15%">Cantidad</th>
                    <th width="12%">Prot.</th>
                    <th width="12%">Carbs</th>
                    <th width="12%">Grasas</th>
                    <th width="12%">Kcal</th>
                </tr>
            </thead>
            <tbody>
                @foreach($items as $item)
                <tr>
                    <td>{{ $item->food->name }}</td>
                    <td class="quantity">{{ $item->quantity }}g</td>
                    <td>{{ round($item->proteins, 1) }}g</td>
                    <td>{{ round($item->carbs, 1) }}g</td>
                    <td>{{ round($item->fats, 1) }}g</td>
                    <td>{{ round($item->calories) }}</td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
    @endforeach

    <div class="footer">
        <div class="logo">CoachPro</div>
        <p>Generado el {{ now()->format('d/m/Y') }} | Este plan fue diseñado especialmente para ti</p>
        <p>Consulta a tu entrenador si tienes dudas sobre los alimentos o porciones</p>
    </div>
</body>
</html>
