<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <title>@yield('title', 'Documento')</title>
    <style>
        /* Reset & Base */
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        @page {
            margin: {{ $settings['pdf_settings']['margin_top'] ?? 20 }}mm {{ $settings['pdf_settings']['margin_right'] ?? 15 }}mm {{ $settings['pdf_settings']['margin_bottom'] ?? 20 }}mm {{ $settings['pdf_settings']['margin_left'] ?? 15 }}mm;
        }
        
        :root {
            --primary-color: {{ $settings['primary_color'] ?? '#3b82f6' }};
            --secondary-color: {{ $settings['secondary_color'] ?? '#f97316' }};
            --accent-color: {{ $settings['accent_color'] ?? '#10b981' }};
        }
        
        body {
            font-family: '{{ $settings['pdf_settings']['font_family'] ?? 'DejaVu Sans' }}', Arial, sans-serif;
            font-size: {{ $settings['pdf_settings']['font_size_base'] ?? 11 }}px;
            line-height: 1.6;
            color: #1f2937;
            background: #ffffff;
        }
        
        /* Typography */
        h1 { font-size: {{ $settings['pdf_settings']['font_size_header'] ?? 24 }}px; font-weight: 700; margin-bottom: 8px; }
        h2 { font-size: 18px; font-weight: 600; margin-bottom: 6px; }
        h3 { font-size: 14px; font-weight: 600; margin-bottom: 4px; }
        p { margin-bottom: 8px; }
        
        /* Dynamic Colors */
        .text-primary { color: {{ $settings['primary_color'] ?? '#3b82f6' }}; }
        .text-secondary { color: {{ $settings['secondary_color'] ?? '#f97316' }}; }
        .text-accent { color: {{ $settings['accent_color'] ?? '#10b981' }}; }
        .text-success { color: #10b981; }
        .text-warning { color: #f59e0b; }
        .text-danger { color: #ef4444; }
        .text-muted { color: #6b7280; }
        .text-white { color: #ffffff; }
        
        .bg-primary { background-color: {{ $settings['primary_color'] ?? '#3b82f6' }}; }
        .bg-secondary { background-color: {{ $settings['secondary_color'] ?? '#f97316' }}; }
        .bg-accent { background-color: {{ $settings['accent_color'] ?? '#10b981' }}; }
        .bg-success { background-color: #10b981; }
        .bg-warning { background-color: #f59e0b; }
        .bg-danger { background-color: #ef4444; }
        .bg-light { background-color: #f3f4f6; }
        .bg-dark { background-color: #1f2937; }
        
        /* Layout */
        .container { max-width: 100%; padding: 0 10px; }
        .row { display: table; width: 100%; }
        .col-6 { display: table-cell; width: 50%; vertical-align: top; }
        .col-4 { display: table-cell; width: 33.33%; vertical-align: top; }
        .col-3 { display: table-cell; width: 25%; vertical-align: top; }
        
        .text-left { text-align: left; }
        .text-center { text-align: center; }
        .text-right { text-align: right; }
        
        .mt-1 { margin-top: 5px; }
        .mt-2 { margin-top: 10px; }
        .mt-3 { margin-top: 15px; }
        .mt-4 { margin-top: 20px; }
        .mb-1 { margin-bottom: 5px; }
        .mb-2 { margin-bottom: 10px; }
        .mb-3 { margin-bottom: 15px; }
        .mb-4 { margin-bottom: 20px; }
        .p-2 { padding: 10px; }
        .p-3 { padding: 15px; }
        .p-4 { padding: 20px; }
        
        /* Modern Header with Coach Info */
        .pdf-header-modern {
            background: linear-gradient(135deg, {{ $settings['primary_color'] ?? '#3b82f6' }}, {{ $settings['secondary_color'] ?? '#1d4ed8' }});
            padding: 25px;
            margin: -20mm -15mm 25px -15mm;
            color: #ffffff;
            position: relative;
        }
        
        .pdf-header-modern::after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 0;
            right: 0;
            height: 4px;
            background: linear-gradient(90deg, {{ $settings['accent_color'] ?? '#10b981' }}, {{ $settings['secondary_color'] ?? '#f97316' }});
        }
        
        .header-top {
            display: table;
            width: 100%;
            margin-bottom: 15px;
        }
        
        .header-logo-area {
            display: table-cell;
            width: 25%;
            vertical-align: middle;
        }
        
        .header-logo-area img {
            max-width: 80px;
            max-height: 60px;
            border-radius: 8px;
        }
        
        .header-logo-text {
            font-size: 24px;
            font-weight: 800;
            color: #ffffff;
            letter-spacing: -0.5px;
        }
        
        .header-title-area {
            display: table-cell;
            width: 50%;
            text-align: center;
            vertical-align: middle;
        }
        
        .header-title-area h1 {
            font-size: 22px;
            font-weight: 700;
            margin-bottom: 4px;
            color: #ffffff;
            text-transform: uppercase;
            letter-spacing: 1px;
        }
        
        .header-title-area .subtitle {
            font-size: 11px;
            opacity: 0.9;
        }
        
        .header-date-area {
            display: table-cell;
            width: 25%;
            text-align: right;
            vertical-align: middle;
            font-size: 10px;
        }
        
        .header-date-area .date-value {
            font-size: 14px;
            font-weight: 600;
        }
        
        /* Coach Info Box */
        .coach-info-box {
            background: rgba(255, 255, 255, 0.15);
            border-radius: 8px;
            padding: 12px 15px;
            margin-top: 15px;
            display: table;
            width: 100%;
        }
        
        .coach-photo-area {
            display: table-cell;
            width: 60px;
            vertical-align: middle;
        }
        
        .coach-photo {
            width: 50px;
            height: 50px;
            border-radius: 50%;
            border: 2px solid rgba(255, 255, 255, 0.5);
            object-fit: cover;
        }
        
        .coach-photo-placeholder {
            width: 50px;
            height: 50px;
            border-radius: 50%;
            background: rgba(255, 255, 255, 0.2);
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 20px;
        }
        
        .coach-details {
            display: table-cell;
            vertical-align: middle;
            padding-left: 10px;
        }
        
        .coach-name {
            font-weight: 600;
            font-size: 13px;
            margin-bottom: 2px;
        }
        
        .coach-credentials {
            font-size: 10px;
            opacity: 0.85;
        }
        
        .coach-contact {
            display: table-cell;
            vertical-align: middle;
            text-align: right;
            font-size: 10px;
        }
        
        .coach-contact-item {
            margin-bottom: 3px;
            opacity: 0.9;
        }
        
        /* Legacy Header (backward compatibility) */
        .pdf-header {
            padding: 20px;
            margin: -20px -15px 25px -15px;
            color: #ffffff;
            position: relative;
        }
        
        .pdf-header-primary { background: linear-gradient(135deg, {{ $settings['primary_color'] ?? '#3b82f6' }}, #1d4ed8); }
        .pdf-header-success { background: linear-gradient(135deg, #10b981, #059669); }
        .pdf-header-warning { background: linear-gradient(135deg, #f97316, #ea580c); }
        .pdf-header-purple { background: linear-gradient(135deg, #8b5cf6, #7c3aed); }
        
        .pdf-header .logo {
            font-size: 20px;
            font-weight: bold;
            opacity: 0.9;
        }
        
        .pdf-header h1 {
            margin-top: 10px;
            color: #ffffff;
        }
        
        .pdf-header p {
            opacity: 0.9;
        }
        
        /* Cards */
        .card {
            border: 1px solid #e5e7eb;
            border-radius: 12px;
            margin-bottom: 15px;
            overflow: hidden;
            box-shadow: 0 1px 3px rgba(0, 0, 0, 0.05);
        }
        
        .card-header {
            padding: 12px 15px;
            font-weight: 600;
            font-size: 12px;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        .card-body {
            padding: 15px;
        }
        
        .card-accent {
            border-left: 4px solid {{ $settings['primary_color'] ?? '#3b82f6' }};
        }
        
        /* Tables */
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 15px;
        }
        
        th, td {
            padding: 10px 12px;
            text-align: left;
            border-bottom: 1px solid #e5e7eb;
        }
        
        th {
            font-weight: 600;
            font-size: 10px;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            color: #374151;
            background-color: #f9fafb;
        }
        
        .table-striped tbody tr:nth-child(even) {
            background-color: #f9fafb;
        }
        
        .table-bordered th,
        .table-bordered td {
            border: 1px solid #e5e7eb;
        }
        
        /* Badges */
        .badge {
            display: inline-block;
            padding: 3px 10px;
            font-size: 9px;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            border-radius: 12px;
        }
        
        .badge-success { background-color: #dcfce7; color: #166534; }
        .badge-warning { background-color: #fef3c7; color: #92400e; }
        .badge-danger { background-color: #fee2e2; color: #dc2626; }
        .badge-info { background-color: #dbeafe; color: #1e40af; }
        .badge-primary { background-color: #ede9fe; color: #5b21b6; }
        .badge-accent { background-color: {{ $settings['accent_color'] ?? '#10b981' }}20; color: {{ $settings['accent_color'] ?? '#10b981' }}; }
        
        /* Stats Box */
        .stats-grid {
            display: table;
            width: 100%;
            margin-bottom: 20px;
        }
        
        .stat-box {
            display: table-cell;
            text-align: center;
            padding: 15px;
            background-color: #f8fafc;
            border: 1px solid #e2e8f0;
        }
        
        .stat-box:first-child { border-radius: 12px 0 0 12px; }
        .stat-box:last-child { border-radius: 0 12px 12px 0; }
        
        .stat-value {
            font-size: 22px;
            font-weight: 700;
            display: block;
        }
        
        .stat-label {
            font-size: 10px;
            color: #6b7280;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        .stat-calories .stat-value { color: #8b5cf6; }
        .stat-protein .stat-value { color: {{ $settings['primary_color'] ?? '#3b82f6' }}; }
        .stat-carbs .stat-value { color: #eab308; }
        .stat-fat .stat-value { color: {{ $settings['secondary_color'] ?? '#f97316' }}; }
        
        /* Day badges */
        .day-badge {
            display: inline-block;
            padding: 4px 10px;
            margin: 2px;
            border-radius: 12px;
            font-size: 9px;
            font-weight: 600;
        }
        
        .day-active {
            background-color: {{ $settings['primary_color'] ?? '#3b82f6' }};
            color: white;
        }
        
        .day-inactive {
            background-color: #e5e7eb;
            color: #9ca3af;
        }
        
        /* Modern Footer */
        .pdf-footer-modern {
            margin-top: 30px;
            padding-top: 20px;
            border-top: 3px solid {{ $settings['primary_color'] ?? '#3b82f6' }};
        }
        
        .footer-content {
            display: table;
            width: 100%;
        }
        
        .footer-brand {
            display: table-cell;
            width: 40%;
            vertical-align: top;
        }
        
        .footer-brand-logo {
            font-size: 16px;
            font-weight: 700;
            color: {{ $settings['primary_color'] ?? '#3b82f6' }};
            margin-bottom: 5px;
        }
        
        .footer-brand-tagline {
            font-size: 10px;
            color: #6b7280;
        }
        
        .footer-contact {
            display: table-cell;
            width: 30%;
            vertical-align: top;
            text-align: center;
            font-size: 10px;
            color: #6b7280;
        }
        
        .footer-contact-item {
            margin-bottom: 3px;
        }
        
        .footer-legal {
            display: table-cell;
            width: 30%;
            vertical-align: top;
            text-align: right;
            font-size: 9px;
            color: #9ca3af;
        }
        
        /* Legacy Footer */
        .pdf-footer {
            margin-top: 30px;
            padding-top: 15px;
            border-top: 2px solid #e5e7eb;
            text-align: center;
            font-size: 10px;
            color: #6b7280;
        }
        
        .pdf-footer .logo {
            font-size: 14px;
            font-weight: bold;
            margin-bottom: 5px;
        }
        
        /* Section */
        .section {
            margin-bottom: 20px;
            page-break-inside: avoid;
        }
        
        .section-title {
            font-weight: 600;
            font-size: 13px;
            color: #374151;
            border-bottom: 2px solid {{ $settings['primary_color'] ?? '#3b82f6' }};
            padding-bottom: 8px;
            margin-bottom: 15px;
        }
        
        .section-title-icon {
            display: inline-block;
            width: 24px;
            height: 24px;
            background: {{ $settings['primary_color'] ?? '#3b82f6' }};
            border-radius: 6px;
            text-align: center;
            line-height: 24px;
            margin-right: 8px;
            color: white;
            font-size: 12px;
        }
        
        /* Info Box */
        .info-box {
            background-color: #f0f9ff;
            border: 1px solid #bae6fd;
            border-radius: 12px;
            padding: 15px;
            margin-bottom: 15px;
        }
        
        .info-box.success {
            background-color: #f0fdf4;
            border-color: #86efac;
        }
        
        .info-box.warning {
            background-color: #fff7ed;
            border-color: #fed7aa;
        }
        
        .info-box.accent {
            background: linear-gradient(135deg, {{ $settings['primary_color'] ?? '#3b82f6' }}10, {{ $settings['accent_color'] ?? '#10b981' }}10);
            border-color: {{ $settings['primary_color'] ?? '#3b82f6' }}40;
        }
        
        /* Page break */
        .page-break {
            page-break-after: always;
        }
        
        /* Watermark */
        .watermark {
            position: fixed;
            bottom: 10mm;
            right: 10mm;
            font-size: 8px;
            color: #d1d5db;
        }
        
        @if(($settings['watermark_enabled'] ?? false) && ($settings['watermark_text'] ?? null))
        .watermark-custom {
            position: fixed;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%) rotate(-45deg);
            font-size: 60px;
            color: rgba(0, 0, 0, 0.05);
            font-weight: bold;
            white-space: nowrap;
            z-index: -1;
        }
        @endif
        
        /* Motivational Quote Box */
        .quote-box {
            background: linear-gradient(135deg, {{ $settings['primary_color'] ?? '#3b82f6' }}15, {{ $settings['secondary_color'] ?? '#f97316' }}15);
            border-left: 4px solid {{ $settings['primary_color'] ?? '#3b82f6' }};
            padding: 15px 20px;
            margin: 20px 0;
            border-radius: 0 12px 12px 0;
        }
        
        .quote-box .quote-text {
            font-size: 12px;
            font-style: italic;
            color: #374151;
            margin-bottom: 5px;
        }
        
        .quote-box .quote-author {
            font-size: 10px;
            color: #6b7280;
            text-align: right;
        }
        
        /* Print optimizations */
        @media print {
            body { -webkit-print-color-adjust: exact; print-color-adjust: exact; }
            .pdf-header { -webkit-print-color-adjust: exact; print-color-adjust: exact; }
            .pdf-header-modern { -webkit-print-color-adjust: exact; print-color-adjust: exact; }
        }
        
        /* Custom CSS from settings */
        {!! $settings['custom_css'] ?? '' !!}
    </style>
    @yield('styles')
</head>
<body>
    @if(($settings['watermark_enabled'] ?? false) && ($settings['watermark_text'] ?? null))
    <div class="watermark-custom">{{ $settings['watermark_text'] }}</div>
    @endif
    
    @yield('content')
    
    @if($settings['show_date'] ?? true)
    <div class="watermark">
        Generado el {{ now()->format('d/m/Y H:i') }}
    </div>
    @endif
</body>
</html>
