<?php

namespace Database\Seeders;

use App\Models\EmailTemplate;
use Illuminate\Database\Seeder;

class StoreEmailTemplatesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $templates = [
            [
                'slug' => 'order-confirmation',
                'name' => 'Confirmación de Pedido',
                'subject' => '¡Gracias por tu pedido! - Orden #{{{order_number}}}',
                'body' => '<div style="font-family: Arial, sans-serif; max-width: 600px; margin: 0 auto;">
    <div style="background: linear-gradient(135deg, #10b981, #059669); padding: 30px; text-align: center; border-radius: 10px 10px 0 0;">
        <h1 style="color: white; margin: 0;">¡Pedido Confirmado! 🎉</h1>
    </div>
    <div style="padding: 30px; background: #f9fafb; border-radius: 0 0 10px 10px;">
        <p style="font-size: 16px; color: #374151;">Hola <strong>{{{customer_name}}}</strong>,</p>
        <p style="font-size: 16px; color: #374151;">Hemos recibido tu pedido y está siendo procesado.</p>
        
        <div style="background: white; border-radius: 8px; padding: 20px; margin: 20px 0; border: 1px solid #e5e7eb;">
            <h3 style="margin: 0 0 15px 0; color: #1f2937;">Detalles del Pedido</h3>
            <p style="margin: 5px 0; color: #6b7280;"><strong>Número de orden:</strong> #{{{order_number}}}</p>
            <p style="margin: 5px 0; color: #6b7280;"><strong>Fecha:</strong> {{{order_date}}}</p>
            <p style="margin: 5px 0; color: #6b7280;"><strong>Total:</strong> <span style="color: #10b981; font-weight: bold;">{{{order_total}}}</span></p>
        </div>

        <div style="background: white; border-radius: 8px; padding: 20px; margin: 20px 0; border: 1px solid #e5e7eb;">
            <h3 style="margin: 0 0 15px 0; color: #1f2937;">Productos</h3>
            {{{order_items}}}
        </div>

        <div style="text-align: center; margin-top: 30px;">
            <a href="{{{order_url}}}" style="display: inline-block; background: #10b981; color: white; padding: 12px 30px; text-decoration: none; border-radius: 8px; font-weight: bold;">Ver Mi Pedido</a>
        </div>

        <p style="font-size: 14px; color: #6b7280; margin-top: 30px;">Si tienes alguna pregunta, no dudes en contactarnos.</p>
        <p style="font-size: 14px; color: #6b7280;">Gracias por confiar en nosotros,<br><strong>{{{app_name}}}</strong></p>
    </div>
</div>',
                'variables' => ['customer_name', 'order_number', 'order_date', 'order_total', 'order_items', 'order_url', 'app_name'],
                'is_active' => true,
            ],
            [
                'slug' => 'order-shipped',
                'name' => 'Pedido Enviado',
                'subject' => '¡Tu pedido está en camino! - Orden #{{{order_number}}}',
                'body' => '<div style="font-family: Arial, sans-serif; max-width: 600px; margin: 0 auto;">
    <div style="background: linear-gradient(135deg, #3b82f6, #1d4ed8); padding: 30px; text-align: center; border-radius: 10px 10px 0 0;">
        <h1 style="color: white; margin: 0;">¡Pedido Enviado! 📦</h1>
    </div>
    <div style="padding: 30px; background: #f9fafb; border-radius: 0 0 10px 10px;">
        <p style="font-size: 16px; color: #374151;">Hola <strong>{{{customer_name}}}</strong>,</p>
        <p style="font-size: 16px; color: #374151;">¡Excelentes noticias! Tu pedido ha sido enviado y está en camino.</p>
        
        <div style="background: white; border-radius: 8px; padding: 20px; margin: 20px 0; border: 1px solid #e5e7eb;">
            <h3 style="margin: 0 0 15px 0; color: #1f2937;">Información de Envío</h3>
            <p style="margin: 5px 0; color: #6b7280;"><strong>Número de orden:</strong> #{{{order_number}}}</p>
            <p style="margin: 5px 0; color: #6b7280;"><strong>Número de seguimiento:</strong> {{{tracking_number}}}</p>
            <p style="margin: 5px 0; color: #6b7280;"><strong>Transportista:</strong> {{{carrier}}}</p>
            <p style="margin: 5px 0; color: #6b7280;"><strong>Fecha estimada de entrega:</strong> {{{estimated_delivery}}}</p>
        </div>

        <div style="background: white; border-radius: 8px; padding: 20px; margin: 20px 0; border: 1px solid #e5e7eb;">
            <h3 style="margin: 0 0 15px 0; color: #1f2937;">Dirección de Entrega</h3>
            <p style="margin: 5px 0; color: #6b7280;">{{{shipping_address}}}</p>
        </div>

        <div style="text-align: center; margin-top: 30px;">
            <a href="{{{tracking_url}}}" style="display: inline-block; background: #3b82f6; color: white; padding: 12px 30px; text-decoration: none; border-radius: 8px; font-weight: bold;">Rastrear Pedido</a>
        </div>

        <p style="font-size: 14px; color: #6b7280; margin-top: 30px;">Si tienes alguna pregunta sobre tu envío, contáctanos.</p>
        <p style="font-size: 14px; color: #6b7280;">Gracias,<br><strong>{{{app_name}}}</strong></p>
    </div>
</div>',
                'variables' => ['customer_name', 'order_number', 'tracking_number', 'carrier', 'estimated_delivery', 'shipping_address', 'tracking_url', 'app_name'],
                'is_active' => true,
            ],
            [
                'slug' => 'order-delivered',
                'name' => 'Pedido Entregado',
                'subject' => '¡Tu pedido ha sido entregado! - Orden #{{{order_number}}}',
                'body' => '<div style="font-family: Arial, sans-serif; max-width: 600px; margin: 0 auto;">
    <div style="background: linear-gradient(135deg, #10b981, #059669); padding: 30px; text-align: center; border-radius: 10px 10px 0 0;">
        <h1 style="color: white; margin: 0;">¡Pedido Entregado! ✅</h1>
    </div>
    <div style="padding: 30px; background: #f9fafb; border-radius: 0 0 10px 10px;">
        <p style="font-size: 16px; color: #374151;">Hola <strong>{{{customer_name}}}</strong>,</p>
        <p style="font-size: 16px; color: #374151;">¡Tu pedido ha sido entregado exitosamente!</p>
        
        <div style="background: white; border-radius: 8px; padding: 20px; margin: 20px 0; border: 1px solid #e5e7eb;">
            <h3 style="margin: 0 0 15px 0; color: #1f2937;">Detalles de Entrega</h3>
            <p style="margin: 5px 0; color: #6b7280;"><strong>Número de orden:</strong> #{{{order_number}}}</p>
            <p style="margin: 5px 0; color: #6b7280;"><strong>Fecha de entrega:</strong> {{{delivery_date}}}</p>
        </div>

        <div style="background: #fef3c7; border-radius: 8px; padding: 20px; margin: 20px 0; border: 1px solid #fcd34d;">
            <h3 style="margin: 0 0 10px 0; color: #92400e;">⭐ ¿Qué te pareció tu compra?</h3>
            <p style="margin: 0; color: #92400e;">Tu opinión es muy importante para nosotros. Déjanos una reseña sobre los productos que recibiste.</p>
        </div>

        <div style="text-align: center; margin-top: 30px;">
            <a href="{{{review_url}}}" style="display: inline-block; background: #f59e0b; color: white; padding: 12px 30px; text-decoration: none; border-radius: 8px; font-weight: bold;">Dejar Reseña</a>
        </div>

        <p style="font-size: 14px; color: #6b7280; margin-top: 30px;">¿Algún problema con tu pedido? Contáctanos y te ayudaremos.</p>
        <p style="font-size: 14px; color: #6b7280;">Gracias por tu compra,<br><strong>{{{app_name}}}</strong></p>
    </div>
</div>',
                'variables' => ['customer_name', 'order_number', 'delivery_date', 'review_url', 'app_name'],
                'is_active' => true,
            ],
            [
                'slug' => 'order-cancelled',
                'name' => 'Pedido Cancelado',
                'subject' => 'Tu pedido ha sido cancelado - Orden #{{{order_number}}}',
                'body' => '<div style="font-family: Arial, sans-serif; max-width: 600px; margin: 0 auto;">
    <div style="background: linear-gradient(135deg, #ef4444, #dc2626); padding: 30px; text-align: center; border-radius: 10px 10px 0 0;">
        <h1 style="color: white; margin: 0;">Pedido Cancelado</h1>
    </div>
    <div style="padding: 30px; background: #f9fafb; border-radius: 0 0 10px 10px;">
        <p style="font-size: 16px; color: #374151;">Hola <strong>{{{customer_name}}}</strong>,</p>
        <p style="font-size: 16px; color: #374151;">Lamentamos informarte que tu pedido ha sido cancelado.</p>
        
        <div style="background: white; border-radius: 8px; padding: 20px; margin: 20px 0; border: 1px solid #e5e7eb;">
            <h3 style="margin: 0 0 15px 0; color: #1f2937;">Detalles del Pedido</h3>
            <p style="margin: 5px 0; color: #6b7280;"><strong>Número de orden:</strong> #{{{order_number}}}</p>
            <p style="margin: 5px 0; color: #6b7280;"><strong>Motivo de cancelación:</strong> {{{cancellation_reason}}}</p>
        </div>

        <div style="background: #dbeafe; border-radius: 8px; padding: 20px; margin: 20px 0; border: 1px solid #93c5fd;">
            <h3 style="margin: 0 0 10px 0; color: #1e40af;">💳 Información de Reembolso</h3>
            <p style="margin: 0; color: #1e40af;">Si realizaste un pago, el reembolso será procesado en un plazo de 5-10 días hábiles.</p>
        </div>

        <div style="text-align: center; margin-top: 30px;">
            <a href="{{{store_url}}}" style="display: inline-block; background: #10b981; color: white; padding: 12px 30px; text-decoration: none; border-radius: 8px; font-weight: bold;">Volver a la Tienda</a>
        </div>

        <p style="font-size: 14px; color: #6b7280; margin-top: 30px;">Si tienes alguna pregunta sobre la cancelación, no dudes en contactarnos.</p>
        <p style="font-size: 14px; color: #6b7280;">Atentamente,<br><strong>{{{app_name}}}</strong></p>
    </div>
</div>',
                'variables' => ['customer_name', 'order_number', 'cancellation_reason', 'store_url', 'app_name'],
                'is_active' => true,
            ],
        ];

        foreach ($templates as $template) {
            EmailTemplate::updateOrCreate(
                ['slug' => $template['slug']],
                $template
            );
        }
    }
}
