<?php

namespace Database\Seeders;

use App\Models\Setting;
use Illuminate\Database\Seeder;

class SettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $settings = [
            // General settings
            [
                'key' => 'site_name',
                'value' => 'CoachPro',
                'group' => 'general',
            ],
            [
                'key' => 'site_description',
                'value' => 'Plataforma SaaS para entrenadores personales',
                'group' => 'general',
            ],
            [
                'key' => 'timezone',
                'value' => 'America/Santo_Domingo',
                'group' => 'general',
            ],
            [
                'key' => 'currency',
                'value' => 'USD',
                'group' => 'general',
            ],
            [
                'key' => 'language',
                'value' => 'es',
                'group' => 'general',
            ],
            
            // SEO settings
            [
                'key' => 'seo_title',
                'value' => 'CoachPro - Gestión para Entrenadores',
                'group' => 'seo',
            ],
            [
                'key' => 'seo_description',
                'value' => 'Plataforma SaaS para coaches y entrenadores personales. Gestiona clientes, dietas y rutinas de forma profesional.',
                'group' => 'seo',
            ],
            [
                'key' => 'seo_keywords',
                'value' => 'coach, entrenador personal, dietas, rutinas, fitness, nutrición',
                'group' => 'seo',
            ],
            
            // Email settings
            [
                'key' => 'mail_from_address',
                'value' => 'noreply@coachpro.com',
                'group' => 'email',
            ],
            [
                'key' => 'mail_from_name',
                'value' => 'CoachPro',
                'group' => 'email',
            ],
            
            // PDF settings
            [
                'key' => 'pdf_header',
                'value' => 'CoachPro - Tu socio en el fitness',
                'group' => 'pdf',
            ],
            [
                'key' => 'pdf_footer',
                'value' => 'Generado por CoachPro | www.coachpro.com',
                'group' => 'pdf',
            ],
            
            // Payment gateways
            [
                'key' => 'paypal_enabled',
                'value' => false,
                'group' => 'payment',
            ],
            [
                'key' => 'stripe_enabled',
                'value' => false,
                'group' => 'payment',
            ],
            [
                'key' => 'bank_transfer_enabled',
                'value' => true,
                'group' => 'payment',
            ],

            // PWA settings
            [
                'key' => 'pwa_enabled',
                'value' => false,
                'group' => 'pwa',
            ],
            [
                'key' => 'pwa_name',
                'value' => 'CoachPro',
                'group' => 'pwa',
            ],
            [
                'key' => 'pwa_short_name',
                'value' => 'CoachPro',
                'group' => 'pwa',
            ],
            [
                'key' => 'pwa_description',
                'value' => 'Plataforma para entrenadores personales',
                'group' => 'pwa',
            ],
            [
                'key' => 'pwa_theme_color',
                'value' => '#3B82F6',
                'group' => 'pwa',
            ],
            [
                'key' => 'pwa_background_color',
                'value' => '#FFFFFF',
                'group' => 'pwa',
            ],
            [
                'key' => 'pwa_display',
                'value' => 'standalone',
                'group' => 'pwa',
            ],

            // Feature toggles
            [
                'key' => 'feature_client_portal',
                'value' => true,
                'group' => 'features',
            ],
            [
                'key' => 'feature_progress_photos',
                'value' => true,
                'group' => 'features',
            ],
            [
                'key' => 'feature_wallet',
                'value' => true,
                'group' => 'features',
            ],
            [
                'key' => 'feature_referrals',
                'value' => true,
                'group' => 'features',
            ],
            [
                'key' => 'feature_pdf_export',
                'value' => true,
                'group' => 'features',
            ],
            [
                'key' => 'feature_chat',
                'value' => true,
                'group' => 'features',
            ],
            [
                'key' => 'feature_compliance_tracking',
                'value' => true,
                'group' => 'features',
            ],
            [
                'key' => 'feature_analytics',
                'value' => true,
                'group' => 'features',
            ],
            [
                'key' => 'feature_custom_foods',
                'value' => true,
                'group' => 'features',
            ],

            // Cron settings
            [
                'key' => 'cron_billing_enabled',
                'value' => false,
                'group' => 'cron',
            ],
            [
                'key' => 'cron_reminders_enabled',
                'value' => false,
                'group' => 'cron',
            ],

            // Notifications settings
            [
                'key' => 'notify_new_user',
                'value' => true,
                'group' => 'notifications',
            ],
            [
                'key' => 'notify_invoice_paid',
                'value' => true,
                'group' => 'notifications',
            ],
            [
                'key' => 'notify_subscription_expired',
                'value' => true,
                'group' => 'notifications',
            ],

            // Legal/Static Pages
            [
                'key' => 'page_about',
                'value' => '<div class="prose dark:prose-invert max-w-none"><h1>Sobre CoachPro</h1><p>CoachPro es la plataforma líder para entrenadores personales y coaches de fitness. Nuestra misión es proporcionar las mejores herramientas para que los profesionales del fitness puedan gestionar sus clientes, crear planes personalizados y hacer crecer su negocio.</p><h2>Nuestra Historia</h2><p>Fundada en 2024, CoachPro nació de la necesidad de simplificar la gestión de clientes para entrenadores personales. Hemos crecido hasta convertirnos en una plataforma integral que ayuda a miles de coaches a nivel mundial.</p><h2>Nuestros Valores</h2><ul><li><strong>Excelencia:</strong> Nos esforzamos por ofrecer la mejor experiencia posible.</li><li><strong>Innovación:</strong> Constantemente mejoramos nuestras herramientas.</li><li><strong>Compromiso:</strong> Tu éxito es nuestro éxito.</li></ul></div>',
                'group' => 'pages',
            ],
            [
                'key' => 'page_terms',
                'value' => '<div class="prose dark:prose-invert max-w-none"><h1>Términos y Condiciones</h1><p><strong>Última actualización:</strong> Enero 2026</p><h2>1. Aceptación de los Términos</h2><p>Al acceder y utilizar CoachPro, aceptas estar sujeto a estos términos y condiciones de uso. Si no estás de acuerdo con alguna parte de estos términos, no debes utilizar nuestros servicios.</p><h2>2. Descripción del Servicio</h2><p>CoachPro es una plataforma SaaS diseñada para entrenadores personales que permite la gestión de clientes, creación de planes de entrenamiento y dietas, seguimiento del progreso y comunicación con clientes.</p><h2>3. Registro y Cuenta</h2><p>Para utilizar nuestros servicios debes crear una cuenta proporcionando información veraz y completa. Eres responsable de mantener la confidencialidad de tu cuenta y contraseña.</p><h2>4. Uso Aceptable</h2><p>Te comprometes a utilizar el servicio de manera legal y ética, respetando los derechos de otros usuarios y no utilizando la plataforma para actividades ilegales.</p><h2>5. Pagos y Suscripciones</h2><p>Los planes de suscripción se facturan según el período seleccionado. Las cancelaciones se procesan al final del período de facturación actual.</p><h2>6. Propiedad Intelectual</h2><p>Todo el contenido de CoachPro está protegido por derechos de autor. Los usuarios mantienen la propiedad de su contenido pero otorgan a CoachPro una licencia para su uso en la plataforma.</p><h2>7. Contacto</h2><p>Para cualquier consulta sobre estos términos, contáctanos a través de nuestro formulario de contacto.</p></div>',
                'group' => 'pages',
            ],
            [
                'key' => 'page_privacy',
                'value' => '<div class="prose dark:prose-invert max-w-none"><h1>Política de Privacidad</h1><p><strong>Última actualización:</strong> Enero 2026</p><h2>1. Información que Recopilamos</h2><p>Recopilamos información que nos proporcionas directamente, como nombre, correo electrónico, información de pago y datos relacionados con tu actividad como coach o cliente.</p><h2>2. Uso de la Información</h2><p>Utilizamos tu información para:</p><ul><li>Proporcionar y mantener nuestros servicios</li><li>Procesar transacciones y enviar notificaciones relacionadas</li><li>Mejorar y personalizar tu experiencia</li><li>Comunicarnos contigo sobre actualizaciones y ofertas</li></ul><h2>3. Compartir Información</h2><p>No vendemos tu información personal. Podemos compartirla con proveedores de servicios que nos ayudan a operar la plataforma, siempre bajo estrictos acuerdos de confidencialidad.</p><h2>4. Seguridad</h2><p>Implementamos medidas de seguridad técnicas y organizativas para proteger tu información contra acceso no autorizado, alteración o destrucción.</p><h2>5. Tus Derechos</h2><p>Tienes derecho a acceder, corregir, eliminar o exportar tus datos personales. Contáctanos para ejercer estos derechos.</p><h2>6. Cookies</h2><p>Utilizamos cookies para mejorar tu experiencia. Consulta nuestra Política de Cookies para más detalles.</p></div>',
                'group' => 'pages',
            ],
            [
                'key' => 'page_cookies',
                'value' => '<div class="prose dark:prose-invert max-w-none"><h1>Política de Cookies</h1><p><strong>Última actualización:</strong> Enero 2026</p><h2>¿Qué son las Cookies?</h2><p>Las cookies son pequeños archivos de texto que se almacenan en tu dispositivo cuando visitas nuestro sitio web. Nos ayudan a recordar tus preferencias y mejorar tu experiencia.</p><h2>Tipos de Cookies que Utilizamos</h2><h3>Cookies Esenciales</h3><p>Necesarias para el funcionamiento básico del sitio, como mantener tu sesión iniciada.</p><h3>Cookies de Rendimiento</h3><p>Nos ayudan a entender cómo los usuarios interactúan con nuestro sitio para mejorarlo.</p><h3>Cookies de Funcionalidad</h3><p>Recuerdan tus preferencias como idioma y configuración de visualización.</p><h2>Control de Cookies</h2><p>Puedes configurar tu navegador para rechazar cookies, aunque esto puede afectar algunas funcionalidades del sitio.</p></div>',
                'group' => 'pages',
            ],
            [
                'key' => 'page_refund',
                'value' => '<div class="prose dark:prose-invert max-w-none"><h1>Política de Reembolso</h1><p><strong>Última actualización:</strong> Enero 2026</p><h2>Garantía de Satisfacción</h2><p>Ofrecemos una garantía de satisfacción de 7 días desde la fecha de tu primera compra. Si no estás satisfecho con nuestros servicios, puedes solicitar un reembolso completo dentro de este período.</p><h2>Cómo Solicitar un Reembolso</h2><p>Para solicitar un reembolso:</p><ol><li>Contacta a nuestro equipo de soporte</li><li>Proporciona tu información de cuenta y motivo de la solicitud</li><li>Procesaremos tu solicitud en un plazo de 5-10 días hábiles</li></ol><h2>Excepciones</h2><p>No se aplicarán reembolsos en los siguientes casos:</p><ul><li>Solicitudes realizadas después de los 7 días</li><li>Violación de nuestros términos de servicio</li><li>Servicios ya consumidos o utilizados completamente</li></ul><h2>Renovaciones</h2><p>Las renovaciones automáticas pueden cancelarse en cualquier momento antes de la fecha de renovación. No se ofrecen reembolsos por períodos de suscripción ya iniciados.</p></div>',
                'group' => 'pages',
            ],
            [
                'key' => 'page_faq',
                'value' => '<div class="prose dark:prose-invert max-w-none"><h1>Preguntas Frecuentes</h1><h2>General</h2><h3>¿Qué es CoachPro?</h3><p>CoachPro es una plataforma SaaS diseñada específicamente para entrenadores personales y coaches de fitness. Te permite gestionar clientes, crear planes personalizados, hacer seguimiento del progreso y mucho más.</p><h3>¿Cómo empiezo a usar CoachPro?</h3><p>Simplemente regístrate en nuestra plataforma, selecciona un plan de suscripción y comienza a agregar tus clientes. Ofrecemos un período de prueba para que explores todas las funcionalidades.</p><h2>Pagos y Suscripciones</h2><h3>¿Qué métodos de pago aceptan?</h3><p>Aceptamos tarjetas de crédito/débito (Visa, MasterCard, American Express), PayPal y transferencias bancarias.</p><h3>¿Puedo cambiar de plan en cualquier momento?</h3><p>Sí, puedes actualizar o degradar tu plan en cualquier momento. Los cambios se aplicarán en tu próximo ciclo de facturación.</p><h3>¿Ofrecen reembolsos?</h3><p>Sí, ofrecemos una garantía de satisfacción de 7 días. Consulta nuestra Política de Reembolso para más detalles.</p><h2>Funcionalidades</h2><h3>¿Puedo personalizar los planes de dieta y entrenamiento?</h3><p>Absolutamente. CoachPro te permite crear planes completamente personalizados para cada cliente.</p><h3>¿Los clientes pueden acceder a la plataforma?</h3><p>Sí, tus clientes tienen acceso a un portal donde pueden ver sus planes, registrar su progreso y comunicarse contigo.</p></div>',
                'group' => 'pages',
            ],
        ];

        foreach ($settings as $setting) {
            Setting::updateOrCreate(
                ['key' => $setting['key']],
                $setting
            );
        }
    }
}
