<?php

namespace Database\Seeders;

use App\Models\ProductCategory;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class ProductCategorySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $categories = [
            ['name' => 'Proteína de suero', 'description' => 'Suplementos de proteína de suero (Whey Protein)'],
            ['name' => 'Creatina', 'description' => 'Suplementos de creatina para fuerza y rendimiento'],
            ['name' => 'Barra de proteínas', 'description' => 'Barras nutritivas con alto contenido proteico'],
            ['name' => 'Glutamina', 'description' => 'Suplementos de glutamina para recuperación muscular'],
            ['name' => 'Diuréticos', 'description' => 'Productos diuréticos naturales'],
            ['name' => 'Hipercalórico', 'description' => 'Ganadores de masa y suplementos hipercalóricos'],
            ['name' => 'Preentrenamiento', 'description' => 'Suplementos pre-workout para energía y enfoque'],
            ['name' => 'Aminoácidos', 'description' => 'BCAAs y aminoácidos esenciales'],
            ['name' => 'Multivitamínico', 'description' => 'Complejos vitamínicos y minerales'],
            ['name' => 'Termogénico', 'description' => 'Quemadores de grasa y termogénicos'],
            ['name' => 'Omega', 'description' => 'Ácidos grasos esenciales Omega 3, 6 y 9'],
            ['name' => 'Colágeno', 'description' => 'Suplementos de colágeno para articulaciones y piel'],
            ['name' => 'Carbohidratos', 'description' => 'Suplementos de carbohidratos y maltodextrina'],
            ['name' => 'Proteína', 'description' => 'Otros tipos de proteína (caseína, vegetal, etc.)'],
            ['name' => 'Gel energético', 'description' => 'Geles y shots energéticos para deportistas'],
            ['name' => 'Moda fitness', 'description' => 'Ropa y vestimenta deportiva'],
            ['name' => 'Accesorios', 'description' => 'Accesorios deportivos y de entrenamiento'],
            ['name' => 'Kits de suplementación', 'description' => 'Packs y combos de suplementos'],
        ];

        $order = 1;
        foreach ($categories as $category) {
            ProductCategory::updateOrCreate(
                ['slug' => \Illuminate\Support\Str::slug($category['name'])],
                [
                    'name' => $category['name'],
                    'description' => $category['description'],
                    'order' => $order,
                    'is_active' => true,
                ]
            );
            $order++;
        }

        $this->command->info('Product categories seeded successfully!');
    }
}
