<?php

namespace Database\Seeders;

use App\Models\PdfSetting;
use Illuminate\Database\Seeder;

class PdfSettingsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $documentTypes = [
            PdfSetting::TYPE_INVOICE,
            PdfSetting::TYPE_WORKOUT,
            PdfSetting::TYPE_MEAL_PLAN,
            PdfSetting::TYPE_STATISTICS,
        ];

        foreach ($documentTypes as $type) {
            PdfSetting::updateOrCreate(
                ['document_type' => $type],
                PdfSetting::getDefaultSettings($type)
            );
        }

        $this->command->info('PDF settings seeded successfully for all document types.');
    }
}
