<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Insert default PWA icon settings
        $pwaIcons = [
            ['key' => 'pwa_icon_16', 'value' => json_encode('/icons/png/icon-16x16.png'), 'group' => 'pwa'],
            ['key' => 'pwa_icon_32', 'value' => json_encode('/icons/png/icon-32x32.png'), 'group' => 'pwa'],
            ['key' => 'pwa_icon_72', 'value' => json_encode('/icons/png/icon-72x72.png'), 'group' => 'pwa'],
            ['key' => 'pwa_icon_96', 'value' => json_encode('/icons/png/icon-96x96.png'), 'group' => 'pwa'],
            ['key' => 'pwa_icon_128', 'value' => json_encode('/icons/png/icon-128x128.png'), 'group' => 'pwa'],
            ['key' => 'pwa_icon_144', 'value' => json_encode('/icons/png/icon-144x144.png'), 'group' => 'pwa'],
            ['key' => 'pwa_icon_152', 'value' => json_encode('/icons/png/icon-152x152.png'), 'group' => 'pwa'],
            ['key' => 'pwa_icon_167', 'value' => json_encode('/icons/png/icon-167x167.png'), 'group' => 'pwa'],
            ['key' => 'pwa_icon_180', 'value' => json_encode('/icons/png/icon-180x180.png'), 'group' => 'pwa'],
            ['key' => 'pwa_icon_192', 'value' => json_encode('/icons/png/icon-192x192.png'), 'group' => 'pwa'],
            ['key' => 'pwa_icon_384', 'value' => json_encode('/icons/png/icon-384x384.png'), 'group' => 'pwa'],
            ['key' => 'pwa_icon_512', 'value' => json_encode('/icons/png/icon-512x512.png'), 'group' => 'pwa'],
            ['key' => 'pwa_icon_maskable_192', 'value' => json_encode('/icons/png/maskable-icon-192x192.png'), 'group' => 'pwa'],
            ['key' => 'pwa_icon_maskable_512', 'value' => json_encode('/icons/png/maskable-icon-512x512.png'), 'group' => 'pwa'],
            ['key' => 'pwa_name', 'value' => json_encode('CoachPro - Plataforma para Entrenadores'), 'group' => 'pwa'],
            ['key' => 'pwa_short_name', 'value' => json_encode('CoachPro'), 'group' => 'pwa'],
            ['key' => 'pwa_theme_color', 'value' => json_encode('#39FF14'), 'group' => 'pwa'],
            ['key' => 'pwa_background_color', 'value' => json_encode('#0A0A0A'), 'group' => 'pwa'],
        ];

        foreach ($pwaIcons as $setting) {
            DB::table('settings')->updateOrInsert(
                ['key' => $setting['key']],
                array_merge($setting, [
                    'created_at' => now(),
                    'updated_at' => now()
                ])
            );
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        DB::table('settings')->whereIn('key', [
            'pwa_icon_16',
            'pwa_icon_32',
            'pwa_icon_72',
            'pwa_icon_96',
            'pwa_icon_128',
            'pwa_icon_144',
            'pwa_icon_152',
            'pwa_icon_167',
            'pwa_icon_180',
            'pwa_icon_192',
            'pwa_icon_384',
            'pwa_icon_512',
            'pwa_icon_maskable_192',
            'pwa_icon_maskable_512',
            'pwa_name',
            'pwa_short_name',
            'pwa_theme_color',
            'pwa_background_color',
        ])->delete();
    }
};
