<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Add Google OAuth fields to users table
        Schema::table('users', function (Blueprint $table) {
            $table->string('google_id')->nullable()->unique()->after('email');
            $table->string('google_token')->nullable()->after('google_id');
            $table->string('google_refresh_token')->nullable()->after('google_token');
            $table->string('google_avatar')->nullable()->after('google_refresh_token');
        });

        // Create oauth_settings table for storing OAuth configuration
        Schema::create('oauth_settings', function (Blueprint $table) {
            $table->id();
            $table->string('provider')->unique(); // google, facebook, etc.
            $table->text('client_id')->nullable();
            $table->text('client_secret')->nullable();
            $table->boolean('is_enabled')->default(false);
            $table->json('scopes')->nullable();
            $table->json('additional_config')->nullable();
            $table->timestamps();
        });

        // Insert default Google OAuth setting
        DB::table('oauth_settings')->insert([
            'provider' => 'google',
            'is_enabled' => false,
            'scopes' => json_encode(['openid', 'profile', 'email']),
            'created_at' => now(),
            'updated_at' => now(),
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn([
                'google_id',
                'google_token',
                'google_refresh_token',
                'google_avatar',
            ]);
        });

        Schema::dropIfExists('oauth_settings');
    }
};
