<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('pdf_settings', function (Blueprint $table) {
            $table->id();
            $table->string('document_type', 50); // invoice, workout, meal_plan, statistics
            
            // Logo and branding
            $table->string('logo')->nullable();
            $table->string('primary_color', 7)->default('#3B82F6');
            $table->string('secondary_color', 7)->default('#F97316');
            $table->string('accent_color', 7)->default('#10B981');
            
            // Header settings
            $table->string('header_title')->nullable();
            $table->text('header_subtitle')->nullable();
            $table->boolean('show_logo')->default(true);
            $table->boolean('show_date')->default(true);
            $table->boolean('show_page_numbers')->default(true);
            
            // Footer settings  
            $table->text('footer_text')->nullable();
            $table->text('footer_note')->nullable();
            $table->string('footer_website')->nullable();
            $table->string('footer_email')->nullable();
            $table->string('footer_phone')->nullable();
            
            // Coach info settings
            $table->boolean('show_coach_info')->default(true);
            $table->boolean('show_coach_photo')->default(false);
            $table->boolean('show_coach_credentials')->default(true);
            $table->boolean('show_coach_contact')->default(true);
            
            // Layout settings
            $table->string('paper_size', 10)->default('a4'); // a4, letter
            $table->string('orientation', 10)->default('portrait'); // portrait, landscape
            $table->integer('margin_top')->default(20);
            $table->integer('margin_bottom')->default(20);
            $table->integer('margin_left')->default(15);
            $table->integer('margin_right')->default(15);
            
            // Typography
            $table->string('font_family', 100)->default('DejaVu Sans');
            $table->integer('font_size_base')->default(11);
            $table->integer('font_size_header')->default(24);
            
            // Additional content
            $table->text('custom_css')->nullable();
            $table->text('watermark_text')->nullable();
            $table->boolean('watermark_enabled')->default(false);
            
            $table->boolean('is_active')->default(true);
            $table->timestamps();
            
            $table->unique('document_type');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('pdf_settings');
    }
};
