<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('meal_items', function (Blueprint $table) {
            $table->string('unit')->nullable()->after('quantity');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('meal_items', function (Blueprint $table) {
            if (Schema::hasColumn('meal_items', 'unit')) {
                $table->dropColumn('unit');
            }
        });
    }
};
