<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('coach_plans', function (Blueprint $table) {
            // Top banner
            $table->string('top_banner_text')->nullable()->after('coach_section_stats');
            $table->boolean('show_top_banner')->default(false)->after('top_banner_text');
            
            // Hero section
            $table->string('hero_badge')->nullable()->after('show_top_banner');
            $table->text('hero_description')->nullable()->after('hero_badge');
            $table->string('hero_cta_text')->nullable()->after('hero_description');
            $table->string('hero_secondary_cta_text')->nullable()->after('hero_cta_text');
            $table->json('hero_stats')->nullable()->after('hero_secondary_cta_text');
            
            // Method section
            $table->string('method_title')->nullable()->after('hero_stats');
            $table->string('method_subtitle')->nullable()->after('method_title');
            $table->json('method_items')->nullable()->after('method_subtitle');
            
            // What includes section
            $table->string('includes_title')->nullable()->after('method_items');
            $table->string('includes_subtitle')->nullable()->after('includes_title');
            $table->json('includes_items')->nullable()->after('includes_subtitle');
            
            // How it works section
            $table->string('how_it_works_title')->nullable()->after('includes_items');
            $table->string('how_it_works_subtitle')->nullable()->after('how_it_works_title');
            $table->json('how_it_works_steps')->nullable()->after('how_it_works_subtitle');
            
            // Navigation links
            $table->json('nav_links')->nullable()->after('how_it_works_steps');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('coach_plans', function (Blueprint $table) {
            $table->dropColumn([
                'top_banner_text',
                'show_top_banner',
                'hero_badge',
                'hero_description',
                'hero_cta_text',
                'hero_secondary_cta_text',
                'hero_stats',
                'method_title',
                'method_subtitle',
                'method_items',
                'includes_title',
                'includes_subtitle',
                'includes_items',
                'how_it_works_title',
                'how_it_works_subtitle',
                'how_it_works_steps',
                'nav_links',
            ]);
        });
    }
};
