<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('banks', function (Blueprint $table) {
            $table->id();
            $table->string('bank_name'); // Nombre del banco (BanReservas, Popular, BHD León, etc.)
            $table->string('account_number'); // Número de cuenta
            $table->enum('account_type', ['savings', 'checking'])->default('savings'); // Ahorro o Corriente
            $table->string('account_holder'); // Nombre del titular
            $table->string('rnc')->nullable(); // RNC o Cédula
            $table->string('currency', 3)->default('DOP'); // DOP, USD
            $table->text('instructions')->nullable(); // Instrucciones adicionales
            $table->boolean('is_active')->default(true);
            $table->integer('sort_order')->default(0); // Orden de visualización
            $table->timestamps();

            $table->index('is_active');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('banks');
    }
};
