<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('compliance_logs', function (Blueprint $blueprint) {
            $blueprint->id();
            $blueprint->foreignId('client_id')->constrained()->onDelete('cascade');
            $blueprint->string('resource_type'); // 'workout' or 'meal'
            $blueprint->unsignedBigInteger('resource_id');
            $blueprint->timestamp('completed_at');
            $blueprint->timestamps();
        });

        Schema::create('progress_photos', function (Blueprint $blueprint) {
            $blueprint->id();
            $blueprint->foreignId('client_id')->constrained()->onDelete('cascade');
            $blueprint->string('image_path');
            $blueprint->string('type')->default('front'); // front, side, back
            $blueprint->decimal('weight', 8, 2)->nullable();
            $blueprint->date('date');
            $blueprint->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('progress_photos');
        Schema::dropIfExists('compliance_logs');
    }
};
