<?php

namespace App\Notifications\Traits;

use App\Services\NotificationSettingsService;

/**
 * Trait for notifications that should respect admin notification settings.
 */
trait ChecksNotificationSettings
{
    /**
     * Determine if the notification should be sent.
     * This is called before via() to check if the notification is enabled.
     */
    public function shouldSend(object $notifiable, string $channel): bool
    {
        return NotificationSettingsService::shouldSend(static::class);
    }
}
