<?php

namespace App\Notifications;

use App\Models\CoachPlanPurchase;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class CoachPlanPaymentReminder extends Notification implements ShouldQueue
{
    use Queueable;

    public function __construct(
        public CoachPlanPurchase $purchase
    ) {}

    public function via($notifiable): array
    {
        // Database first to ensure in-app notification is saved even if mail fails
        return ['database', 'mail'];
    }

    public function toMail($notifiable): MailMessage
    {
        $plan = $this->purchase->coachPlan;

        return (new MailMessage)
            ->subject('Recordatorio de pago - ' . $plan->name)
            ->greeting('¡Hola ' . $this->purchase->buyer_name . '!')
            ->line('Te recordamos que tu pago para el plan **' . $plan->name . '** está pendiente.')
            ->line('**Monto:** $' . number_format($this->purchase->amount, 2))
            ->line('Para mantener tu acceso activo, por favor realiza el pago lo antes posible.')
            ->action('Realizar pago', route('public.coach-plan', $plan->slug))
            ->line('Si ya realizaste el pago, por favor ignora este mensaje o sube tu comprobante.');
    }

    public function toArray($notifiable): array
    {
        return [
            'type' => 'coach_plan_payment_reminder',
            'purchase_id' => $this->purchase->id,
            'plan_id' => $this->purchase->coach_plan_id,
            'plan_name' => $this->purchase->coachPlan->name,
            'amount' => $this->purchase->amount,
            'message' => 'Recordatorio: Tu pago para el plan ' . $this->purchase->coachPlan->name . ' está pendiente.',
        ];
    }
}
