<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class BroadcastNotification extends Notification implements ShouldQueue
{
    use Queueable;

    protected string $subject;
    protected string $message;
    protected array $channels;

    /**
     * Create a new notification instance.
     */
    public function __construct(string $subject, string $message, array $channels = ['database'])
    {
        $this->subject = $subject;
        $this->message = $message;
        $this->channels = $channels;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return $this->channels;
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject($this->subject)
            ->greeting("Hola {$notifiable->name},")
            ->line($this->message)
            ->line('---')
            ->line('Este mensaje fue enviado por el administrador de ' . config('app.name') . '.')
            ->salutation('Saludos, ' . config('app.name'));
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        return [
            'type' => 'broadcast',
            'subject' => $this->subject,
            'message' => $this->message,
            'from' => 'admin',
        ];
    }

    /**
     * Get the notification's database type.
     */
    public function databaseType(object $notifiable): string
    {
        return 'broadcast';
    }
}
