<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class PhotoComment extends Model
{
    protected $fillable = [
        'progress_photo_id',
        'author_name',
        'comment',
        'likes_count',
        'ip_address',
    ];

    protected $casts = [
        'likes_count' => 'integer',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];

    /**
     * Get the photo that owns the comment
     */
    public function photo(): BelongsTo
    {
        return $this->belongsTo(ProgressPhoto::class, 'progress_photo_id');
    }
}
