<?php

namespace App\Console\Commands;

use App\Models\User;
use App\Models\Client;
use App\Models\Plan;
use Illuminate\Console\Command;

class CheckUsers extends Command
{
    protected $signature = 'app:check-users';
    protected $description = 'Check all users in the database';

    public function handle()
    {
        $this->info('All Users:');
        $users = User::all();
        foreach ($users as $user) {
            $this->line("ID: {$user->id}, Name: {$user->name}, Role: {$user->role}, Status: {$user->status}");
        }
        
        $this->newLine();
        $this->info('Client Users and their clientProfile:');
        $clientUsers = User::where('role', 'client')->get();
        foreach ($clientUsers as $user) {
            $profile = $user->clientProfile;
            $this->line("User ID: {$user->id}, Name: {$user->name}");
            if ($profile) {
                $this->line("  -> Has clientProfile: ID={$profile->id}, client_user_id={$profile->client_user_id}, user_id(coach)={$profile->user_id}");
            } else {
                $this->line("  -> NO clientProfile found!");
            }
        }
        
        $this->newLine();
        $this->info('All Clients in DB:');
        $clients = Client::all();
        foreach ($clients as $client) {
            $this->line("Client ID: {$client->id}, Name: {$client->name}, user_id(coach): {$client->user_id}, client_user_id: " . ($client->client_user_id ?? 'NULL'));
        }
    }
}
